#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
speed_loop.py

Purpose:
    Check speed of computation loops versus vectorisation

Version:
    1       First start

Date:
    2018/8/29

Author:
    Charles Bos
"""
###########################################################
### Imports
import numpy as np
from lib.inctime import *

###########################################################
### main
def main():
    iN= 10000
    iR= 1000
    vY= np.random.randn(iN, 1)
    vDY= np.zeros_like(vY)

    with Timer("Loop"):
      for r in range(iR):
          for i in range(iN):
              if (vY[i] > 0):
                  vDY[i]= 1
              else:
                  vDY[i]= -1

    with Timer("Matrix"):
      for r in range(iR):
          vDY= np.ones_like(vY)
          vDY[vY <= 0]= -1

    # Output
    print ("Quite a difference...\n")

###########################################################
### start main
if __name__ == "__main__":
    main()
