#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
DrawStack.py

Purpose:
    Draw the stackloss data

Inputs:
    The program expects the file data/stackloss.csv to contain
    the data

Version:
    1       Based on stackols2.py

Date:
    2005/2/16, 2017/7/24, 2017/8/18

Author:
    Charles Bos
"""
###########################################################
### Imports
import pandas as pd
import numpy as np
import matplotlib.pyplot as plt

###########################################################
### main
def main():
    # Magic numbers
    sData= 'data/stackloss.csv'
    sY= 'Stack Loss'
    asX= ['Air Flow', 'Water Temperature', 'Acid Concentration']
    sBase= 'stack'

    # Initialisation
    df= pd.read_csv(sData)      # Read csv into dataframe
    vY= df[sY].values           # Extract y-variable
    mX= df[asX].values          # Extract x-variables

    plt.plot(vY, 'r+')
    plt.legend([sY])
    plt.savefig('graphs/stackdata_y.png')
    plt.show()

    iK= len(asX)
    for i in range(0,iK):
        plt.subplot(1,iK,i+1)
        plt.plot(mX[:,i], vY, 'r+')
        plt.title(asX[i])

    plt.subplot(1,iK,1)
    plt.ylabel(sY)
    plt.savefig('graphs/stackdata_xy.png')
    plt.show()


###########################################################
### start main
if __name__ == "__main__":
    main()
