#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
eststack_ml.py

Purpose:
    Estimate a regression model on the stackloss data set

Inputs:
    The program expects the file data/stackloss.csv to contain
    the data

Version:
    1       based on stackols3.py, and estnorm.py

Date:
    2005/2/16, 2017/7/24

Author:
    Charles Bos
"""
###########################################################
### Imports
import pandas as pd
import numpy as np
import matplotlib.pyplot as plt

# Import module with stackloss functions
from lib.incstack import *

###########################################################
### main
def main():
    # Magic numbers
    sData= 'data/stackloss.csv'
    sY= 'Stack Loss'
    asX= ['Air Flow', 'Water Temperature', 'Acid Concentration']
    sOut= 'stack'

    # Initialisation
    (vY, mX)= ReadStack(sData, sY, asX, True)
    asX= ['Const']+asX

    # Estimation
    (vP, vS, dLL, sMess)= EstStack_ML(vY, mX)

    # Output
    OutputStack_ML(np.vstack([vP, vS]), dLL, sMess, asX)

###########################################################
### start main
if __name__ == "__main__":
    main()
