#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
StackOls.py

Purpose:
    Estimate a regression model on the stackloss data set

Inputs:
    The program expects the file data/stackloss.csv to contain
    the data

Version:
    2       Version Python, using functions
    3       Using functions from library

Date:
    2005/2/16, 2017/7/24

Author:
    Charles Bos
"""
###########################################################
### Imports
import pandas as pd
import numpy as np
import matplotlib.pyplot as plt

# Import module with stackloss functions
from lib.incstack import *

###########################################################
### main
def main():
    # Magic numbers
    sData= 'data/stackloss.csv'
    sY= 'Stack Loss'
    asX= ['Air Flow', 'Water Temperature', 'Acid Concentration']
    sOut= 'stack'

    # Initialisation
    (vY, mX)= ReadStack(sData, sY, asX, True)
    asX= ['constant']+asX

    # Estimation
    (vBeta, dS2)= EstStack(vY, mX)

    # Output
    OutputStack(vBeta, dS2, vY, mX, sY, asX, 'graphs/'+sOut)

###########################################################
### start main
if __name__ == "__main__":
    main()
