#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
plot1.py

Purpose:
    Display simple capabilities of matplotlib

Version:
    1       First start

Date:
    2017/8/18

Author:
    Charles Bos
"""
###########################################################
### Imports
import numpy as np
import matplotlib.pyplot as plt

###########################################################
### main
def main():
    # Magic numbers
    iN= 100
    iK= 3

    # Initialisation
    mY= np.random.randn(iN, iK)

    # Output
    plt.figure(figsize=(8, 6))      # Choose alternate size
    plt.subplot(2, 1, 1)            # Work with 2x1 grid, first plot
    plt.plot(mY)                    # Simply plot the white noise
    plt.legend(["a", "b", "c"])     # Add a legend
    plt.title("White noise")        # ... and a title

    plt.subplot(2, 1, 2)            # Start with second plot
    plt.plot(mY[:,0], mY[:,1:], ".")  # Plot here some cross-plots
    plt.ylabel("b,c")
    plt.xlabel("a")
    plt.title("Unrelated data")     # ... and name the graph
    plt.savefig("graphs/plot1.png") # Save the result
    plt.show()                      # Done, show it

###########################################################
### start main
if __name__ == "__main__":
    main()
