#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
plot1_df.py

Purpose:
    Display simple capabilities of matplotlib, using a dataframe, and axes

Version:
    1       First start

Date:
    2017/8/18

Author:
    Charles Bos
"""
###########################################################
### Imports
import numpy as np
import matplotlib.pyplot as plt
import pandas as pd

###########################################################
### main
def main():
    # Initialisation
    mY= np.random.randn(100, 3)
    df= pd.DataFrame(mY, columns=["a", "b", "c"])
    
    # Output
    (fig, axes)= plt.subplots(2, 1) # Work with 2x1 grid
    fig.set_size_inches(8,6)
    df.plot(ax=axes[0])             # Simply plot the dataframe, on first subplot
    axes[0].set_title("White noise")        # ... and a title

    # Build a cross-plot, in second subplot
    df.plot(x="a", y=["b", "c"], style=".", ax=axes[1])
    axes[1].set_title("Unrelated data")     # ... and a second title
    plt.savefig("graphs/plot1_df.png")
    plt.show()                      # Done, show it
    
###########################################################
### start main
if __name__ == "__main__":
    main()
