#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
plottime.py

Purpose:
    Make a time series plot

Version:
    1       First start

Date:
    2023/9/2

Author:
    Charles Bos
"""
###########################################################
### Imports
import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
import matplotlib.dates as mdates

#########################################################
### DrawTMatrix(vT, vY, label= None, format= '%H:%M', color= 'r')
def DrawTMatrix(vT, vY, label= None, format= '%H:%M', color= 'r'):
    """
    Purpose:
        Plot a time series, with specified format on the x-axis

    Inputs:
        vT          iT vector, datetime (including date as well!)
        vY          iT vector, y-values
        label       (optional, default= None) string, label
        format      (optional, default= '%H:%M') string, format to show
    """
    plt.plot(vT, vY, label=label, color= color)
    ax= plt.gca()
    fmTime = mdates.DateFormatter(format)
    ax.xaxis.set_major_formatter(fmTime)

###########################################################
### main
def main():
    # Magic numbers
    iN= 100
    sD1= '2023/9/1'

    # Initialisation
    vD= pd.date_range(sD1, periods= iN, freq= 'D')

    # Estimation
    vY= np.random.randn(iN)

    # Output
    plt.figure()
    DrawTMatrix(vD, vY, format= '%Y/%m/%d')
    plt.show()

###########################################################
### start main
if __name__ == "__main__":
    main()
