"""
pow5.py

Purpose:
    Calculate 2^8

Version:
    0       Outline of a program
    1       Start initialisation and calculations
    2       Calculate the answer, using a loop
    3       Use a function for calculating the power
    4       Introduce a while loop instead
    5       Try out recursion

Date:
    2023/7/29

Author:
    Charles Bos
"""
###########################################################
### Imports
# import numpy as np
# import scipy as sp
# import matplotlib.pyplot as plt

###########################################################
### dRes= Pow(dBase, iPow)
def Pow(dBase, iPow):
    """
    Purpose:
      Calculate dBase^iPow

    Inputs:
      dBase     double, base
      iPow      integer, power

    Return value:
      dRes      double, dBase^iPow
    """
    dRes= 1
    i= 0
    while (i < iPow):
        # print (f'i= {i}')
        dRes= dRes * dBase
        i+= 1

    return dRes

###########################################################
### dRes= Pow_Recursion(dBase, iPow)
def Pow_Recursion(dBase, iPow):
    """
    Purpose:
      Calculate dBase^iPow through recursion

    Inputs:
      dBase     double, base
      iPow      integer, power

    Return value:
      dRes      double, dBase^iPow
    """
    # print (f'In Pow_Recursion, with iPow= {iPow}')
    if (iPow == 0):
        return 1

    return dBase * Pow_Recursion(dBase, iPow-1)

###########################################################
### main
def main():
    # Magic numbers
    dBase= 2
    iC= 8

    # Initialisation

    # Estimation
    # dRes= Pow(dBase, iC)
    dRes= Pow_Recursion(dBase, iC)

    # Output
    print (f'The result of {dBase}^{iC}= {dRes}')

###########################################################
### start main
if __name__ == "__main__":
    main()
