"""
pow6.py

Purpose:
    Calculate 2^8

Version:
    0       Outline of a program
    1       Start initialisation and calculations
    2       Calculate the answer, using a loop
    3       Use a function for calculating the power
    4       Introduce a while loop instead
    5       Try out recursion
    6       Check the outcome

Date:
    2023/7/29

Author:
    Charles Bos
"""
###########################################################
### Imports
# import numpy as np
import math

###########################################################
### dRes= Pow(dBase, iPow)
def Pow(dBase, iPow):
    """
    Purpose:
      Calculate dBase^iPow

    Inputs:
      dBase     double, base
      iPow      integer, power

    Return value:
      dRes      double, dBase^iPow
    """
    dRes= 1
    i= 0
    while (i < iPow):
        # print (f'i= {i}')
        dRes= dRes * dBase
        i+= 1

    return dRes

###########################################################
### dRes= Pow_Recursion(dBase, iPow)
def Pow_Recursion(dBase, iPow):
    """
    Purpose:
      Calculate dBase^iPow through recursion

    Inputs:
      dBase     double, base
      iPow      integer, power

    Return value:
      dRes      double, dBase^iPow
    """
    # print (f'In Pow_Recursion, with iPow= {iPow}')
    if (iPow == 0):
        return 1

    return dBase * Pow_Recursion(dBase, iPow-1)

###########################################################
### main()
def main():
    # Magic numbers
    dBase= 2
    iC= 8

    # Estimation

    # Output
    print (f'The result of {dBase}^{iC}=')
    print (f'  - Using Pow(): {Pow(dBase, iC)}')
    print (f'  - Using Pow_Recursion(): {Pow_Recursion(dBase, iC)}')
    print (f'  - Using **: {dBase ** iC}')
    print (f'  - Using math.pow: {math.pow(dBase, iC)}')

###########################################################
### start main
if __name__ == "__main__":
    main()
