#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
exrandom_burr12.py

Purpose:
    Display usage of novel random number generators, with Burr-12 distribution

Version:
    1       First start

Date:
    2024/6/30

Author:
    Charles Bos
"""
###########################################################
### Imports
import numpy as np
import scipy.stats as st
import scipy.special as ss

###########################################################
### main
def main():
    # Magic numbers
    iSeed= 1234
    iN= 100
    dC= 1
    dD= 3

    # Initialisation
    rng= np.random.default_rng(iSeed)   # Initialise the random number generator/seed

    # Estimation
    vY= st.burr12.rvs(c= dC, d= dD, size= iN, random_state= rng)          # Use the Burr12 from scipy
    # vM= st.burr12.stats(c= dC, d= dD)           # Theoretical moments SciPy

    dM1= dD*ss.beta((dC*dD-1)/dC, (dC+1)/dC)
    dM2= dD*ss.beta((dC*dD-2)/dC, (dC+2)/dC)
    dS2= -dM1**2 + dM2

    # Output
    print (f'Results for {iN} draws from Burr12(c={dC}, d={dD}): ')
    print (f'Empirical:   m= {np.mean(vY):.4f}, s2= {np.var(vY):.4f}')
    # print (f'Theoretical SciPy: m= {vM[0]:.4f}, s2= {vM[1]:.4f}')
    print (f'Theoretical: m= {dM1:.4f}, s2= {dS2:.4f}')

###########################################################
### start main
if __name__ == "__main__":
    main()
