#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
exrandom_novel.py

Purpose:
    Display usage of novel random number generators

Version:
    1       First start

Date:
    2024/6/30

Author:
    Charles Bos
"""
###########################################################
### Imports
import numpy as np

###########################################################
### main
def main():
    # Magic numbers
    iSeed= 1234
    iN= 100

    # Initialisation
    rng= np.random.default_rng(iSeed)   # Initialise the random number generator/seed

    # Estimation
    vY= rng.normal(size= iN)

    # Output
    print (f'Mean and variance of {iN} draws from N(0, 1): m= {np.mean(vY):.4f}, s2= {np.var(vY):.4f}')

###########################################################
### start main
if __name__ == "__main__":
    main()
