#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
recap4.py

Purpose:
    Study matrices versus vectors, and indexing

Date:
    2017/7/13

Author:
    Charles Bos
"""
###########################################################
### Imports
import numpy as np

###########################################################
### main
def main():
    vX= np.array([1, 2, 3]).reshape(3, 1)   # A column vector

    print ('vX=\n', vX)
    print ('Note how vX is a lists-of-lists, cast to a two-dimensional array\n')

    print ('vX= ', vX, ' with type ', type(vX),
           ' and size ', np.shape(vX))
    print ('vX[0]= ', vX[0], ' with type ', type(vX[0]),
           ' and size ', np.shape(vX[0]))
    print ('vX[0,0]= ', vX[0,0], ' with type ', type(vX[0,0]),
           ' and size ', np.shape(vX[0,0]))
    print ('vX[0:1]= ', vX[0:1], ' with type ', type(vX[0:1]),
           ' and size ', np.shape(vX[0:1]))

###########################################################
### start main
if __name__ == "__main__":
    main()
