#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
recap5.py

Purpose:
    Study indexing further

Date:
    2017/7/16

Author:
    Charles Bos
"""
###########################################################
### Imports
import numpy as np

###########################################################
### showelement(aElem)
def showelement(sElem, aElem):
    print (sElem, '= ', aElem, ' with type ', type(aElem),
           ' with shape ', np.shape(aElem), ', size ', np.size(aElem),
           ' and len ', len(aElem))

###########################################################
### main
def main():
    lX= [[1, 2, 'hello'],
         ['there', 'A', 4.5]]
    print ('Show the full list:')
    showelement('lX', lX)               # a two-dimensional list
    print ('Reference first list:')
    showelement('lX[0]', lX[0])         # a one-dimensional list
    print ('Reference the third element [2] of the first list lX[0]:')
    showelement('lX[0][2]', lX[0][2])   # a string

    print ('It would be incorrect to reference lX[0,2]')
    # showelement('lX[0,2]', lX[0,2])   # an error...

###########################################################
### start main
if __name__ == "__main__":
    main()
