#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
recap7.py

Purpose:
    Test scope of variables

Note:
    Don't use globals, unless there is absolutely no way of escaping them! They lead to programs extremely hard to debug...

Version:
    1       Local variables only
    2       Include a global

Date:
    2017/7/16

Author:
    Charles Bos
"""
###########################################################
### localfunc(iX)
def localfunc(iX):
    global g_lX
    print ('In localfunc: argument iX: ', iX)
    print ('In localfunc: g_lX: ', g_lX)

    g_lX[1]= iX       # Change a single element
    print ('In localfunc: g_lX after changing an element: ', g_lX)

    g_lX= list(range(iX, 2*iX))   # Change the full variable
    print ('In localfunc: g_lX, after changing all: ', g_lX)

###########################################################
### main
def main():
    global g_lX

    iY= 5
    g_lX= [1, 2, 3]
    localfunc(iY)
    print ('In main: Global var= ', g_lX)

###########################################################
### start main
if __name__ == "__main__":
    main()
