#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
speed_argument.py

Purpose:
    Check speed of return versus argument

Version:
    1       First start

Date:
    2018/8/29

Author:
    Charles Bos
"""
###########################################################
### Imports
import numpy as np
from lib.inctime import *

###########################################################
### mX= funcret(mX)
def funcret(mX):
    (iN, iK)= mX.shape
    mY= np.random.randn(iN, iK)
    return mY

###########################################################
### funcarg(mX)
def funcarg(mX):
    (iN, iK)= mX.shape
    mX[:,:]= np.random.randn(iN, iK)

###########################################################
### main
def main():
    iN= 1000
    iK= 100
    iR= 1000

    mX= np.zeros((iN, iK))
    with Timer("return"):
      for r in range(iR):
        mX= funcret(mX)

    with Timer("argument"):
      for r in range(iR):
        funcarg(mX)

    # Output
    print ("No true difference to be found...\n")

###########################################################
### start main
if __name__ == "__main__":
    main()
