#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
speed_builtin.py

Purpose:
    Check speed of using builtin function instead of my own

Version:
    1       First start

Date:
    2018/8/29

Author:
    Charles Bos
"""
###########################################################
### Imports
import numpy as np
from lib.inctime import *

###########################################################
### vB= MyOls(vY, mX)
def MyOls(vY, mX):
    vB= np.linalg.inv(mX.T@mX)@mX.T@vY
    return vB

###########################################################
### main
def main():
    iN= 1000
    iK= 50
    iR= 1000

    vBeta= np.arange(iK).reshape(-1, 1)
    mX= np.hstack([np.ones((iN, 1)), np.random.rand(iN, iK-1)])
    vY= mX@vBeta + np.random.randn(iN, 1)

    with Timer("MyOls"):
      for r in range(iR):
        vB= MyOls(vY, mX)

    with Timer("lstsq"):
      for r in range(iR):
        vB= np.linalg.lstsq(mX, vY, rcond=None)[0]

    # Output
    print ("Builtin function is slower?!? Must be because it is more stable, more options...\n")

###########################################################
### start main
if __name__ == "__main__":
    main()
