#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
speed_concat.py

Purpose:
    Check speed of concatenating or predeclaring a matrix

Version:
    1       First start

Date:
    2018/8/29

Author:
    Charles Bos
"""
###########################################################
### Imports
import numpy as np
from lib.inctime import *

###########################################################
### main
def main():
    iN= 2000
    iK= 1000

    mX= np.empty((0, iK))
    with Timer('concat'):
      for j in range(iN):
        mX= np.concatenate([mX, np.random.randn(1, iK)])
    print (f'mX: {mX.shape}')

    mX= np.empty((0, iK))
    with Timer('vstack'):
      for j in range(iN):
        mX= np.vstack([mX, np.random.randn(1, iK)])
    print (f'mX: {mX.shape}')

    mXt= np.empty((iK, 0))
    with Timer('hstack columns'):
      for j in range(iN):
        mXt= np.hstack([mXt, np.random.randn(iK, 1)])
    print (f'mXt: {mXt.shape}')

    avXt= []
    with Timer('append list'):
      for j in range(iN):
        avXt.append(np.random.randn(iK))
    mX= np.concatenate(avXt).reshape(iN, iK)
    print (f'mX: {mX.shape}')

    mX= np.empty((iN, iK))
    with Timer('predef'):
      for j in range(iN):
        mX[j,:]= np.random.randn(1, iK)
    print (f'mX: {mX.shape}')

    # Output
    print ('Concatenation is horrendous...')

###########################################################
### start main
if __name__ == '__main__':
    main()
