#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
speed_loop.py

Purpose:
    Check speed of computation using loop versus matrix

Version:
    1       First start

Date:
    2018/8/29

Author:
    Charles Bos
"""
###########################################################
### Imports
import numpy as np
from lib.inctime import *

###########################################################
### Loop(mX, iR)
def Loop(mX, iR):
    """
    Purpose:
        Pass time computing R times X'X, in a loop

    Inputs:
        mX  iN x iK matrix
        iR  integer, number of repetitions

    Return value:
        mXtX    iK x iK matrix of X'X
    """
    (iN, iK)= mX.shape
    for r in range(iR):
        mXtX= np.zeros((iK, iK))
        for i in range(iK):
            for j in range(i+1):
                for k in range(iN):
                    mXtX[i,j]+= mX[k,i] * mX[k,j]
                mXtX[j, i]= mXtX[i, j]
    return mXtX

###########################################################
### MatMult(mX, iR)
def MatMult(mX, iR):
    """
    Purpose:
        Pass time computing R times X'X, using numpy

    Inputs:
        mX  iN x iK matrix
        iR  integer, number of repetitions

    Return value:
        mXtX    iK x iK matrix of X'X
    """
    for r in range(iR):
        mXtX= mX.T@mX
    return mXtX

###########################################################
### main
def main():
    # Magic numbers
    iN= 100
    iK= 10
    iR= 1000

    # Initialisation
    mX= np.hstack([np.ones((iN, 1)), np.random.randn(iN, iK-1)])

    print ("Calculation X'X for (%i x %i) matrix X, repeating R=%i times" % (iN, iK, iR))

    # Estimation
    with Timer("Loop, Rx"):
        mXtX= Loop(mX, iR)
    with Timer("MatMult, Rx"):
        mXtX= MatMult(mX, iR)

    # Output
    print ("Quite a difference...\n")

###########################################################
### start main
if __name__ == "__main__":
    main()
