#
#  StackOls
#
#  Purpose:
#    Estimate a regression model on the stackloss data set
#
#  Inputs:
#    The program expects the file data/stackloss.txt to contain
#    the data
#
#  Author:
#    Charles Bos
#
#  Date:
#    20/9/2006
#
load data/stackloss.txt;                          # Load the data
vY= stackloss(4,:)';                              # Read out row 4
mX= stackloss(1:3, :)';                           # Read our row 0-2
[vBeta, dSigma, vR]= ols(vY, mX);                 # Run OLS on columns
  
printf ("Ols estimates of Beta: ");
printf ("%6.2f", vBeta');
printf ("\ndSigma gives %5.3f", dSigma);
printf ("\nvR gives\n");
printf ("%6.2f", vR');
printf ("\n");
