#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
StackOls.py

Purpose:
    Estimate a regression model on the stackloss data set

Inputs:
    The program expects the file data/stackloss.csv to contain
    the data

Version:
    1       Version Python

Date:
    2005/2/16, 2017/7/24

Author:
    Charles Bos
"""
###########################################################
### Imports
import pandas as pd
import numpy as np
# import scipy as sp
# import matplotlib.pyplot as plt

###########################################################
### main
def main():
    # Magic numbers
    sData= 'data/stackloss.csv'
    sY= 'Stack Loss'
    asX= ['Air Flow', 'Water Temperature', 'Acid Concentration']

    # Initialisation
    df= pd.read_csv(sData)      # Read csv into dataframe
    vY= df[sY].values           # Extract y-variable
    mX= df[asX].values          # Extract x-variables

    iN= vY.size                 # Check number of observations
    mX= np.hstack([np.ones((iN, 1)), mX])       # Append a vector of 1s
    asX= ['constant']+asX

    # Estimation
    vBeta= np.linalg.lstsq(mX, vY, rcond=None)[0]           # Run OLS y= X beta + e

    # Output
    print ('Ols estimates')
    print (pd.DataFrame(vBeta, index=asX, columns=['beta']))

###########################################################
### start main
if __name__ == "__main__":
    main()
