#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
view_copy.py

Purpose:
    Touch upon the object/view concept in Python

Version:
    1       First start

Date:
    2018/8/25

Author:
    Charles Bos
"""
###########################################################
### Imports
import numpy as np
# import pandas as pd
# import matplotlib.pyplot as plt

###########################################################
### main
def main():
    mX= np.arange(6)+1.0   # Get vector of numbers 1.0, 2.0, .., 6.0
    print ('Shape :', mX.shape)
    mX.shape= (2, 3)     # Assign TO shape characteristic
    print ('Shape :', mX.shape)
    print ('What is mX now?\n', mX)
    mY= mX               # New view of mX
    mY[0, 0]= 0          # Change element of Y
    print ('What is mX now, after changing element of Y?\n', mX)
    print ('Is mX the same as mY? ', id(mX) == id(mY))
    print (f'id(mX)={id(mX)}, id(mY)={id(mY)}')

    mY= mX.copy()        # New copy of mX
    mY[0, 0]= -1
    print ('What is mX now, after re-copying y, putting a -1 in first location?\n', mX)
    print ('What is mY now?\n', mY)
    print ('Is mX the same as mY? ', id(mX) == id(mY))
    print (f'id(mX)={id(mX)}, id(mY)={id(mY)}')

###########################################################
### start main
if __name__ == "__main__":
    main()
