#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
view_copy.py

Purpose:
    Touch upon the object/view concept in Python

Version:
    1       First start
    2       Show usage, altering mutable in function

Date:
    2018/8/25

Author:
    Charles Bos
"""
###########################################################
### Imports
import numpy as np
# import pandas as pd
# import matplotlib.pyplot as plt

###########################################################
### dR= FillRes(mRes)
def FillRes(mRes):
    """
    Purpose:
        Perform (fake) calculating, filling mRes column by column

    Inputs:
        mRes    iR x iC matrix, to be overwritten

    Outputs:
        mRes    iR x iC matrix, filled by column

    Return value:
        dR      double, sum of all results
    """
    (iR, iC)= mRes.shape
    dR= 0.0
    for c in range(iC):
        vC= np.random.randn(iR)      # Do computations. Here: Get R random outcomes
        mRes[:,c]= vC
        dR+= vC.sum()

    return dR

###########################################################
### main
def main():
    # Magic numbers
    iR= 3
    iC= 5

    # Initialisation
    mRes= np.zeros((iR, iC))

    # Estimation
    dR= FillRes(mRes)

    # Output
    print ('The sum of all elements is r= %g' % dR)
    print ('The full matrix mRes=\n', mRes)


###########################################################
### start main
if __name__ == "__main__":
    main()
