#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
view_copy_df.py

Purpose:
    Touch upon the object/view concept in Python, using dataframes

Version:
    1       First start

Date:
    2018/8/25, 2025/8/28

Author:
    Charles Bos
"""
###########################################################
### Imports
import numpy as np
import pandas as pd
# import matplotlib.pyplot as plt

###########################################################
### main
def main():
    mX= np.arange(6)+1.0   # Get vector of numbers 1.0, 2.0, .., 6.0
    print ('Shape :', mX.shape)
    mX.shape= (2, 3)     # Assign TO shape characteristic
    print ('Shape :', mX.shape)
    print ('What is mX now?\n', mX)

    # Move to a dataframe, new view of mX
    dfY= pd.DataFrame(mX)

    dfY.loc[0, 0]= 0          # Change element of Y
    print ('What is mX now, after changing element of dfY?\n', mX)
    print ('Is mX the same as dfY? ', id(mX) == id(dfY))
    print ('IDs are NOT the same, as one is a matrix, the other a dataframe; still, CONTENTS are the same!')
    print (f'id(mX)={id(mX)}, id(dfY)={id(dfY)}')

    dfY= pd.DataFrame(mX).copy()        # New copy of mX, as a dataframe
    dfY.loc[0, 0]= -1
    print ('What is mX now, after re-copying y, putting a -1 in first location?\n', mX)
    print ('What is dfY now?\n', dfY)
    print ('Is mX the same as dfY? ', id(mX) == id(dfY))
    print (f'id(mX)={id(mX)}, id(dfY)={id(dfY)}')

###########################################################
### start main
if __name__ == "__main__":
    main()
