#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
view_copy_df2.py

Purpose:
    Touch upon the object/view concept in Python, using dataframes and selections
    See e.g. https://note.nkmk.me/en/python-pandas-view-copy/ :
        It is hard to come up with a clear and stable example where you get a view, not truly consistent?

Version:
    1       First start

Date:
    2018/8/25, 2025/8/28

Author:
    Charles Bos
"""
###########################################################
### Imports
import numpy as np
import pandas as pd
# import matplotlib.pyplot as plt

###########################################################
### main
def main():
    iN= 5
    dfX= pd.DataFrame({'Count': np.arange(iN), 'One': [1]*iN})
    print ('What is dfX, starting point?\n', dfX)

    # new view of part of dfX
    dfY= dfX.iloc[:2]
    dfY.loc[0, 'One']= 10          # Change element of Y
    print ('What is dfY now?\n', dfY)
    print ('What is dfX now, after changing element of dfY?\n', dfX)
    print ('Mind the warning: Often, not always in my experience, you get a warning...')
    print (f'Is this dfY a view? {dfY._is_view}')
    print ('Is dfX the same as dfY? ', id(dfX) == id(dfY))
    print (f'id(dfX)={id(dfX)}, id(dfY)={id(dfY)}')

    dfY= dfX.iloc[:4].copy()        # New copy of dfX, as a dataframe
    dfY.loc[0, 'One']= -10
    print ('What is dfX now, after re-copying y, putting a -10 in first location of One?\n', dfX)
    print ('What is dfY now?\n', dfY)
    print (f'Is this dfY a view? {dfY._is_view}')
    print ('Is dfX the same as dfY? ', id(dfX) == id(dfY))
    print (f'id(dfX)={id(dfX)}, id(dfY)={id(dfY)}')

###########################################################
### start main
if __name__ == "__main__":
    main()
