#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
inctest.py

Purpose:
    Show how one can include some routines from a Notebook, or from a true program.

Version:
    1       First start

Date:
    2020/8/4

Author:
    Charles Bos
"""
###########################################################
### Imports
import numpy as np
# import pandas as pd
# import matplotlib.pyplot as plt

###########################################################
### vX= InitTest(iX)
def InitTest(iX):
    """
    Purpose:
        Provide an example of an initialisation routine

    Inputs:
        iX      integer, requested size

    Return value:
        vX      iX vector of random data
    """
    vX= np.random.randn(iX)

    return vX

###########################################################
### br= SquareMe(vX)
def SquareMe(vX):
    """
    Purpose:
        Square all elements in vX

    Inputs:
        vX      vector, one-dimensional

    Outputs:
        vX      vector, one-dimensional, elements squared

    Return value:
        br      boolean, True if all went well
    """
    iX= vX.shape[0]
    for i in range(iX):
        vX[i]= vX[i]**2

    # All is well if there are no missings at all
    return not np.any(np.isnan(vX))

###########################################################
### main
def main():
    # Magic numbers
    iX= 4

    # Initialisation
    vX= InitTest(iX)

    # Estimation
    vX0= np.copy(vX)
    br= SquareMe(vX)

    # Output
    print ("This is a main for testing this inctest.py file\n")
    print ("vX0= ", vX0)
    print ("vX= ", vX)
    print ("Apparently,", "all is well" if br else "something went wrong")

###########################################################
### start main
if __name__ == "__main__":
    main()
